#if (!requireNamespace("BiocManager", quietly = TRUE))
install.packages("BiocManager")

BiocManager::install("chromPlot")
BiocManager::install("TxDb.Mmusculus.UCSC.mm10.knownGene")


library("TxDb.Mmusculus.UCSC.mm10.knownGene")
library(GenomicFeatures)
library(chromPlot)

merged <- read.table("~/Desktop/reads.merged.bed")
colnames(merged) = c("Chrom", "Start", "End", "Coverage")
data("mm10_gap")

G <- TxDb.Mmusculus.UCSC.mm10.knownGene
tG <- transcripts(G)
chromPlot(gaps = mm10_cytoBandIdeo, annot1=merged, statCol=4, annot2=tG,chrSide=c(-1,1,1,1,1,1,1,1), colAnnot2 = "Blue", title = "dsRNA vs Gene expression in mouse testes
          Red = dsRNA, Blue = Genes")
chromPlot(gaps=mm10_gap, annot1=merged,
          segment=tG, chrSide=c(-1,1,1,1,1,1,1,1), )